<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Format;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Json format view helper.
 *
 * Renders input as JSON.
 */
class JsonViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param mixed $value The value to render.
     * @param bool $escapeSingleQuotes Escape single quote characters.
     * @param bool $escapeDoubleQuotes Escape double quote characters.
     * @return string
     */
    public function render(
        $value = null,
        bool $escapeSingleQuotes = false,
        bool $escapeDoubleQuotes = false
    ): string {
        if (!$value) {
            $value = $this->renderChildren();
        }
        $flags = 0;
        if ($escapeSingleQuotes) {
            $flags |= JSON_HEX_APOS;
        }
        if ($escapeDoubleQuotes) {
            $flags |= JSON_HEX_QUOT;
        }

        return (string) json_encode($value, $flags);
    }
}
