<?php

namespace Newland\NeosViewHelpers\Tests\Unit\ViewHelpers\String;

use Neos\FluidAdaptor\Tests\Unit\ViewHelpers\ViewHelperBaseTestcase;
use Newland\NeosViewHelpers\ViewHelpers\String\NotEmptyViewHelper;
use PHPUnit\Framework\TestCase;

class NotEmptyViewHelperTest extends ViewHelperBaseTestcase
{

    public function testStringIsEmptyIfItContainsNoCharacters(): void
    {
        $viewHelper = new NotEmptyViewHelper();
        $this->prepareArguments($viewHelper, [ 'string' => '' ]);
        $this->assertFalse(($viewHelper)->render());
    }

    public function testStringIsEmptyIfItContainsWhitespace(): void
    {
        $viewHelper = new NotEmptyViewHelper();

        $this->prepareArguments($viewHelper, [ 'string' => '   ' ]);
        $this->assertFalse($viewHelper->render(), 'Spaces should be ignored');

        $this->prepareArguments($viewHelper, [ 'string' => "\t" ]);
        $this->assertFalse(($viewHelper)->render(), 'Tab character should be ignored');

        $this->prepareArguments($viewHelper, [ 'string' => "\n" ]);
        $this->assertFalse(($viewHelper)->render(), 'Newlines should be ignored');
    }

    public function testStringIsEmptyIfItContainsHtmlEncodedWhitespace(): void
    {
        $viewHelper = new NotEmptyViewHelper();
        $this->prepareArguments($viewHelper, [ 'string' => '&nbsp;' ]);
        $this->assertFalse($viewHelper->render(), '&nbsp; should be ignored');
    }

    public function testStringIsNotEmptyIfItContainsRegularCharacters(): void
    {
        $viewHelper = new NotEmptyViewHelper();
        $this->prepareArguments($viewHelper, [ 'string' => 'foobar' ]);
        $this->assertTrue($viewHelper->render(), '"foobar" is not empty');
    }

    public function testStringIsNotEmptyIfItContainsRegularCharactersSurroundedByWhitespace(): void
    {
        $viewHelper = new NotEmptyViewHelper();
        $this->prepareArguments($viewHelper, [ 'string' => "    foobar\t" ]);
        $this->assertTrue($viewHelper->render());
    }

    public function testEvaluatesChildrenIfNoStringGiven(): void
    {
        $called = false;
        $renderChildren = function () use (&$called) {
            $called = true;
        };

        $viewHelper = new NotEmptyViewHelper();
        $this->prepareArguments($viewHelper);
        $viewHelper->setRenderChildrenClosure($renderChildren);
        $viewHelper->render();

        $this->assertTrue($called, 'Children should have been rendered');
    }
}
