<?php
namespace Newland\NeosViewHelpers\Tests\Unit\ViewHelpers\Format;

use Neos\FluidAdaptor\Tests\Unit\ViewHelpers\ViewHelperBaseTestcase;
use Newland\NeosViewHelpers\ViewHelpers\Format\PrefixViewHelper;

class PrefixViewHelperTest extends ViewHelperBaseTestcase
{

    public function testStringIsTheSameIfNoPrefixIsDefined(): void
    {
        $viewHelper = new PrefixViewHelper();
        $this->prepareArguments($viewHelper, ['string' => 'foobar']);
        $this->assertSame($viewHelper->render(), 'foobar');

        $viewHelper = new PrefixViewHelper();
        $this->prepareArguments($viewHelper, ['string' => 'foobar', 'query' => 'foo']);
        $this->assertSame(($viewHelper)->render(), 'foobar');
    }

    public function testStringChangesIfNoQueryIsDefined(): void
    {
        $viewHelper = new PrefixViewHelper();
        $this->prepareArguments($viewHelper, ['string' => 'foobar', 'query' => null, 'prefix' => 'pre']);
        $this->assertSame($viewHelper->render(), 'prefoobar');
    }

    public function testStringIsTheSameIfQueryExists(): void
    {
        $viewHelper = new PrefixViewHelper();
        $this->prepareArguments($viewHelper, ['string' => 'foobar', 'query' => 'foo', 'prefix' => 'pre']);
        $this->assertSame($viewHelper->render(), 'foobar');
    }

    public function testStringChangesIfQueryIsNotFound(): void
    {
        $viewHelper = new PrefixViewHelper();
        $this->prepareArguments($viewHelper, ['string' => 'foobar', 'query' => 'false', 'prefix' => 'pre']);
        $this->assertSame($viewHelper->render(), 'prefoobar');
    }

    public function testStringChangesIfQueryIsLongerThanString(): void
    {
        $viewHelper = new PrefixViewHelper();
        $this->prepareArguments($viewHelper, ['string' => 'foobar', 'query' => 'foobarbaz', 'prefix' => 'pre']);
        $this->assertSame($viewHelper->render(), 'prefoobar');
    }

    public function testEvaluatesChildrenIfNoStringGiven(): void
    {
        $called = false;
        $renderChildren = function() use (&$called) {
            $called = true;
        };

        $viewHelper = new PrefixViewHelper();
        $this->prepareArguments($viewHelper);
        $viewHelper->setRenderChildrenClosure($renderChildren);
        $viewHelper->render();

        $this->assertTrue($called, 'Children should have been rendered');
    }
}
