<?php declare(strict_types=1);

namespace Newland\NeosViewHelpers\Tests\Unit\ViewHelpers\Collection;

use InvalidArgumentException;
use Newland\NeosViewHelpers\Tests\Unit\ViewHelperTestCase;

class GetViewHelperTest extends ViewHelperTestCase
{

    /** @dataProvider provideCollections */
    public function testExtractsKeyFromArrayPassedInline($collection, $key, $expected): void
    {
        $this->view->assignMultiple(compact('collection', 'key'));
        $this->view->setTemplateSource('{collection -> vh:collection.get(key: key)}');
        $this->assertEquals($expected, $this->view->render());
    }

    /** @dataProvider provideCollections */
    public function testExtractsKeyFromArrayPassedAsAttribute($collection, $key, $expected): void
    {
        $this->view->assignMultiple(compact('collection', 'key'));
        $this->view->setTemplateSource('<vh:collection.get collection="{collection}" key="{key}" />');
        $this->assertEquals($expected, $this->view->render());
    }

    public function provideCollections(): array
    {
        return [
            'valid' => [ [ 'foo' => 'FOO' ], 'foo', 'FOO' ],
            'key not found' => [ [ 'foo' => 'FOO' ], 'bar', null ],
        ];
    }

    public function testThrowsExceptionIfCollectionIsNotArray(): void
    {
        $this->expectException(InvalidArgumentException::class);
        $this->view->setTemplateSource('<vh:collection.get collection="some string" key="foo" />');
        $this->view->render();
    }

    public function testThrowsHelpfulExceptionIfStringInterpolationFails(): void
    {
        $this->expectExceptionMessageMatches('/fluid rendering/');

        $this->view->assign('collection', [ 'foo' => 'FOO' ]);
        $this->view->setTemplateSource('
            <vh:collection.get key="foo">
                {collection}
            </vh:collection.get>
        ');
        $this->view->render();
    }

    public function testThrowsHelpfulExceptionIfNoCollectionPassed(): void
    {
        $this->expectExceptionMessageMatches(
            '/vh:collection.get must receive a collection using either the `collection`\s+attribute or pipes \/ children evaluation./'
        );

        $this->view->setTemplateSource('<vh:collection.get key="foo" />');
        $this->view->render();
    }

}
