<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Type;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Is array view helper.
 *
 * Checks if a given value is of type array.
 */
class IsArrayViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'mixed', 'The value to check.');
    }

    public function render(): bool
    {
        return is_array($this->arguments['value']);
    }
}
