<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Round view helper.
 *
 * Rounds given input.
 */
class RoundViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'mixed', 'The value to round.');
        $this->registerArgument('precision', 'int', 'Number of digits after decimal point.', false, 0);
    }

    public function render(): float
    {
        $value = $this->arguments['value'];

        if (!$value) {
            $value = $this->renderChildren();
        }
        return round((float) $value, $this->arguments['precision']);
    }
}
