<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Format;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Json format view helper.
 *
 * Renders input as JSON.
 */
class JsonViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'mixed', 'The value to render.', false, '');
        $this->registerArgument('escapeSingleQuotes', 'boolean', 'Escape single quote characters.', false, false);
        $this->registerArgument('escapeDoubleQuotes', 'boolean', 'Escape double quote characters.', false, false);
    }

    public function render(): string
    {
        $value = $this->arguments['value'];

        if (!$value) {
            $value = $this->renderChildren();
        }
        $flags = 0;
        if ($this->arguments['escapeSingleQuotes']) {
            $flags |= JSON_HEX_APOS;
        }
        if ($this->arguments['escapeDoubleQuotes']) {
            $flags |= JSON_HEX_QUOT;
        }

        return (string) json_encode($value, $flags);
    }
}
