<?php declare(strict_types=1);

/*
 * Copyright (c) 2023, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\NeosViewHelpers\ViewHelpers;

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\NeosViewHelpers\ViewHelpers\Controller\PaginationController;

class PaginationViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @var PaginationController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('currentPage', 'integer', 'Number of the currently active page', true);
        $this->registerArgument('totalPageCount', 'integer', 'Total number of pages', true);
    }

    public function render(): string
    {
        return $this->initiateSubRequest();
    }
}
