<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Format;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Prefix format view helper.
 *
 * Set a prefix to a string.
 * A query can be used to compare the first characters of
 * the string and only set a prefix if they are different.
 *
 * @example
 * {format.link -> f:format.prefix(query: 'http', prefix: 'http://')}
 */
class PrefixViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('string', 'string', 'String that is modified.');
        $this->registerArgument('query', 'string', 'Prefix which is checked for.');
        $this->registerArgument('prefix', 'string', 'Prefix to set if none is defined.');
    }

    public function render(): string
    {
        $string = $this->arguments['string'] ?? $this->renderChildren();

        if ($this->arguments['query'] && str_starts_with($string, $this->arguments['query'])) {
            return $string;
        }

        return $this->arguments['prefix'] . $string;
    }
}
