<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

class RangeViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('start', 'int', '', true);
        $this->registerArgument('end', 'int', '', true);
        $this->registerArgument('step', 'float', '', false, 1.0);
    }

    public function render(): array
    {
        return range($this->arguments['start'], $this->arguments['end'], $this->arguments['step']);
    }
}
