<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

class IncludesValueViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('collection', 'array', '', false, []);
        $this->registerArgument('value', 'mixed', '', false, '');
    }

    public function render(): bool
    {
        if (!is_array($this->arguments['collection'])) {
            return false;
        }
        return in_array($this->arguments['value'], $this->arguments['collection']);
    }
}
