<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Implode view helper.
 *
 * Implodes a collection.
 */
class ImplodeViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('glue', 'string', 'The glue.', true);
        $this->registerArgument('collection', 'array', '');
    }

    public function render(): string
    {
        if (!$this->arguments['collection']) {
            return '';
        }

        return implode($this->arguments['collection'], $this->arguments['glue']);
    }
}
