<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Cache;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cache\CacheManager;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Get from cache view helper.
 *
 * Gets a key from a cache.
 */
class GetViewHelper extends AbstractViewHelper
{
    /**
     * @Flow\Inject
     * @var CacheManager
     */
    protected $cacheManager;

    public function initializeArguments(): void
    {
        $this->registerArgument('cache', 'string', 'Name of the cache.', true);
        $this->registerArgument('key', 'string', 'Name of the cache key.', true);
    }

    public function render()
    {
        return $this->cacheManager->getCache($this->arguments['cache'])->get($this->arguments['key']);
    }
}
