<?php declare(strict_types=1);

namespace Newland\NeosViewHelpers\Tests\Mock;

use Closure;
use Neos\Flow\Log\ThrowableStorageInterface;

class ThrowableStorageMock implements ThrowableStorageInterface
{
    public array $loggedThrowables = [];

    /**
     * Writes information about the given exception into the log.
     *
     * @api
     */
    public function logThrowable(\Throwable $throwable, array $additionalData = [])
    {
        $this->loggedThrowables[] = $throwable;
    }

    /**
     * Set a closure that returns information about the current request to be stored with the exception.
     * Note this is not yet public API and bound to change.
     *
     * @return self
     */
    public function setRequestInformationRenderer(Closure $requestInformationRenderer)
    {
        return $this;
    }

    /**
     * Set a closure that takes a backtrace array and returns a representation useful for this storage.
     * Note this is not yet public API and bound to change.
     *
     * @return self
     */
    public function setBacktraceRenderer(Closure $backtraceRenderer)
    {
        return $this;
    }

    public static function createWithOptions(array $options): ThrowableStorageInterface
    {
        return new static();
    }
}
