<?php
namespace Newland\NeosViewHelpers\Tests\Unit\ViewHelpers\Format;

use Newland\NeosViewHelpers\Tests\Unit\ViewHelperTestCase;

class HumanReadableListViewHelperTest extends ViewHelperTestCase
{

    /** @dataProvider provideInputData */
    public function testRendersResultingListCorrectly(array $arguments, string $inner, string $expected): void
    {
        $argumentsString = '';
        foreach ($arguments as $name => $value) {
            $this->view->assign($name, $value);
            $argumentsString .= sprintf(' %s="{%s}" ', $name, $name);
        }

        $this->view->setTemplateSource(sprintf(
             '<vh:format.humanReadableList %s>%s</vh:format.humanReadableList>',
             $argumentsString,
             $inner
         ));
        $result = $this->view->render();

        $this->assertEquals($expected, $result);
    }

    public function provideInputData(): array
    {
        return [
            'normal' => [
                'arguments' => [
                    'each' => ['foo', 'bar', 'baz'],
                    'as' => 'someVar'
                ],
                'inner' => '[{someVar}]',
                'expected' => '[foo], [bar], [baz]'
            ],
            'trimmedInner' => [
                'arguments' => [
                    'each' => ['foo', 'bar', 'baz'],
                    'as' => 'someVar'
                ],
                'inner' => '   [{someVar}]    ',
                'expected' => '[foo], [bar], [baz]'
            ],
            'reverse' => [
                'arguments' => [
                    'each' => ['foo', 'bar', 'baz'],
                    'as' => 'someVar',
                    'reverse' => true
                ],
                'inner' => '[{someVar}]',
                'expected' => '[baz], [bar], [foo]'
            ],
            'customGlue' => [
                'arguments' => [
                    'each' => ['foo', 'bar', 'baz'],
                    'as' => 'someVar',
                    'glue' => '|'
                ],
                'inner' => '{someVar}',
                'expected' => 'foo|bar|baz'
            ],
            'deepData' => [
                'arguments' => [
                    'each' => [ [ 'content' => 'foo' ], [ 'content' => 'bar' ], [ 'content' => 'baz' ] ],
                    'as' => 'someVar'
                ],
                'inner' => '[{someVar.content}]',
                'expected' => '[foo], [bar], [baz]'
            ],
        ];
    }

}
