<?php
namespace Newland\NeosViewHelpers\Tests\Unit\ViewHelpers\Format;

use Newland\NeosViewHelpers\ViewHelpers\Format\CropViewHelper;
use PHPUnit\Framework\TestCase;

class CropViewHelperTest extends TestCase
{
    private CropViewHelper $subject;

    private array $arguments = [
        'input' => "It's Supercalifragilisticexpialidocious!",
        'append' => '...',
        'respectWordBoundaries' => true,
    ];

    public function setUp(): void
    {
        $this->subject = new CropViewHelper();
    }

    public function testCropWithCuttingOffAWord(): void
    {
        $this->subject->setArguments(
            array_merge(
                $this->arguments,
                [
                    'maxCharacters' => 14,
                    'respectWordBoundaries' => false,
                ]
            )
        );
        $this->assertEquals("It's Supercali...", $this->subject->render());
    }

    public function testCropRightAfterWord(): void
    {
        $this->subject->setArguments(array_merge($this->arguments, [ 'maxCharacters' => 4 ]));
        $this->assertEquals("It's...", $this->subject->render());
    }

    public function testCropRightAfterSpace(): void
    {
        $this->subject->setArguments(array_merge($this->arguments, [ 'maxCharacters' => 5 ]));
        $this->assertEquals("It's...", $this->subject->render());
    }

    public function testCropInsideExcedingWord(): void
    {
        $this->subject->setArguments(array_merge($this->arguments, [ 'maxCharacters' => 6 ]));
        $this->assertEquals("It's...", $this->subject->render());
    }

    public function testCropRightAfterString(): void
    {
        $this->subject->setArguments(array_merge($this->arguments, [ 'maxCharacters' => 40 ]));
        $this->assertEquals("It's Supercalifragilisticexpialidocious!", $this->subject->render());
    }

    public function testCropAfterTotalStringLength(): void
    {
        $this->subject->setArguments(array_merge($this->arguments, [ 'maxCharacters' => 100 ]));
        $this->assertEquals("It's Supercalifragilisticexpialidocious!", $this->subject->render());
    }

    public function testCropAfterTwoShortWords(): void
    {
        $this->subject->setArguments(
            array_merge(
                $this->arguments,
                [
                    'input' => 'For a spoonful of sugar',
                    'maxCharacters' => 5,
                ]
            )
        );
        $this->assertEquals('For a...', $this->subject->render());
    }

    public function testCropAfterTwoShortWordsWithTags(): void
    {
        $this->subject->setArguments(
            array_merge(
                $this->arguments,
                [
                    'input' => '<strong>For</strong> a spoonful of sugar',
                    'maxCharacters' => 5,
                ]
            )
        );
        $this->assertEquals('For a...', $this->subject->render());
    }

    public function testUsesRegularCropIfNoWordBoundariesExist(): void
    {
        $this->subject->setArguments(
            [
                'input' => 'Supercalifragilisticexpialidocious',
                'maxCharacters' => 10,
                'respectWordBoundaries' => true,
                'append' => '...',
            ]
        );
        $this->assertEquals('Supercalif...', $this->subject->render());
    }
}
