<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Format;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Prefix format view helper.
 *
 * Set a prefix to a string.
 * A query can be used to compare the first characters of
 * the string and only set a prefix if they are different.
 *
 * @example
 * {format.link -> f:format.prefix(query: 'http', prefix: 'http://')}
 */
class PrefixViewHelper extends AbstractViewHelper
{
    /**
     * @param string|null $string   String that is modified.
     * @param string|null $query    Prefix which is checked for.
     * @param string|null $prefix   Prefix to set if none is defined.
     * @return string
     */
    public function render(string $string = null, string $query = null, string $prefix = null): string
    {
        $string = $string ?? $this->renderChildren();

        if ($query && substr($string, 0, strlen($query)) === $query) {
            return $string;
        }

        return $prefix . $string;
    }
}
