<?php declare(strict_types=1);

namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

/**
 * FilterByBooleanInPath ViewHelper
 *
 * Filters a collection for items where the property at a given path is true/false.
 */
class FilterByBooleanInPathViewHelper extends AbstractViewHelper
{
    use CompileWithRenderStatic;

    protected $escapeOutput = false;
    protected $escapeChildren = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('collection', 'array', 'The array to filter', true);
        $this->registerArgument('path', 'string', 'The path to the value to test in dot notation', true);
        $this->registerArgument('filtered', 'string', 'The name of the filtered array', true);
        $this->registerArgument('bool', 'boolean', 'The value to test against', false, true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $templateVariableContainer = $renderingContext->getVariableProvider();

        $bits = explode('.', $arguments['path']);
        $bool = (bool) $arguments['bool'];

        $filtered = array_filter(
            $arguments['items'] ?? [],
            static function (array $item) use ($bits, $bool) {
                foreach ($bits as $bit) {
                    if (!is_array($item)) {
                        return false;
                    }
                    $item = $item[$bit];
                }

                return ((bool) $item) === $bool;
            }
        );

        $templateVariableContainer->add($arguments['filtered'], $filtered);

        return $renderChildrenClosure();
    }
}
