<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Is not negative view helper.
 *
 * Checks if a given value is greater than '0'. This has been
 * implemented because fluid evaluates '0' as false.
 */
class IsNotNegativeViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param mixed $value      The value to check.
     * @return bool
     */
    public function render($value): bool
    {
        return ($value !== null && $value >= 0);
    }
}
