<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Implode view helper.
 *
 * Implodes a collection.
 */
class ImplodeViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param string $glue
     * @param array $collection
     * @return string
     */
    public function render($glue, array $collection = null): string
    {
        if (!$collection) {
            return '';
        }

        return implode($collection, $glue);
    }
}
