# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.6.0] - 2019-07-12
### Added
- New [`vh:generate.random` ViewHelper](./Classes/ViewHelpers/Generate/RandomViewHelper.php)
  returns a fresh, random id. Useful for linking dynamic elements on a page.
- New [`vh:render` ViewHelper](./Classes/ViewHelpers/RenderViewHelper.php)
  that wraps `f:render` with more forgiving error handling in production environments.

## [1.5.0] - 2019-06-06
### Added
- New [`vh:translate` ViewHelper ](./Classes/ViewHelpers/TranslateiewHelper.php)
  uses fallback languages if a translation is missing in the requested language.

### Fixed
- Fixed type confusion in `vh:media.inline` viewhelper
  
## [1.4.0] - 2019-05-07
### Added
- [`vh:format.crop` ViewHelper ](./Classes/ViewHelpers/Format/CropViewHelper.php)
    was added to crop a string to a given length.

### Changes
- `vh:media.inline` now inlines SVGs as is

### Breaking
- Minimum PHP version requirement is now PHP7.2

## [1.3.0] - 2019-04-18
- [`vh:format.prefix` ViewHelper ](./Classes/ViewHelpers/Format/PrefixViewHelper.php)
  was added to add a prefix to a string.
- [`vh:form.honeypot` ViewHelper ](./Classes/ViewHelpers/Form/HoneypotViewHelper.php)
  was added to add a simple honeypot field to forms.

## [1.2.0] - 2019-04-02
### Added
- [`vh:uri.resource` ViewHelper](./Classes/ViewHelpers/Uri/ResourceViewHelper.php) for Cache Busting:
  ResourceViewHelper with appended file content hash always forces fresh download of the updated version and
  is a drop-in replacement for `f:uri.resource`.
- [`vh:string.notEmpty`](./Classes/ViewHelpers/String/NotEmptyViewHelper.php) now has a `ignoreEmptyTags`
  option that will remove any HTML tags before checking for emptyness thereby ignoring empty HTML tags.

## [1.1.1] - 2019-03-28
No functional changes.

## [1.1.0] - 2019-03-08
### Added
- [`vh:string.notEmpty` ViewHelper ](./Classes/ViewHelpers/String/NotEmptyViewHelper.php)
  was added that makes checking for empty strings (including some edge cases like `&nbsp;`) easier.
- [`vh:type.isDateTime` ViewHelper ](./Classes/ViewHelpers/Type/IsDateTimeViewHelper.php) to
  check if the given value is a DateTime object.
- [`vh:type.isObject` ViewHelper ](./Classes/ViewHelpers/Type/IsObjectViewHelper.php) to check if
  the given value is an object in general.
- [`vh:collection.includesValue` ViewHelper ](./Classes/ViewHelpers/Collection/IncludesValueViewHelper.php) to check if the
  given collection / array contains a certain item.
- [`vh:collection.merge` ViewHelper ](./Classes/ViewHelpers/Collection/MergeViewHelper.php) to merge two
  collections / arrays.
- [`vh:collection.range` ViewHelper ](./Classes/ViewHelpers/Collection/RangeViewHelper.php) to get a new
  collection / array of numbers from a given minimum to a given maximum.
- [`vh:format.currency` ViewHelper ](./Classes/ViewHelpers/Format/CurrencyViewHelper.php) as a pre-configured version
  of the native `f:format.currency` viewhelper.
- [`vh:math.divide` ViewHelper ](./Classes/ViewHelpers/Math/DivideViewHelper.php) to divide two numbers in
  order to overcome some fluid limitations.
- [`vh:cache.get` ViewHelper ](./Classes/ViewHelpers/Cache/GetViewHelper.php) to fetch data from the cache.


### Fixed
- Package is now compatible with Neos 3.3
- `vh:math.toHours` viewhelper now zero-pads single-digit numbers
