<?php
namespace Newland\NeosViewHelpers\Tests\ViewHelpers\String;

use Newland\NeosViewHelpers\ViewHelpers\Format\PrefixViewHelper;
use PHPUnit\Framework\TestCase;

class PrefixViewHelperTest extends TestCase
{

    public function testStringIsTheSameIfNoPrefixIsDefined()
    {
        $this->assertTrue((new PrefixViewHelper())->render('foobar', null, null) === 'foobar');
        $this->assertTrue((new PrefixViewHelper())->render('foobar', 'foo', null) === 'foobar');
    }

    public function testStringChangesIfNoQueryIsDefined()
    {
        $this->assertTrue((new PrefixViewHelper())->render('foobar', null, 'pre') === 'prefoobar');
    }

    public function testStringIsTheSameIfQueryExists()
    {
        $this->assertTrue((new PrefixViewHelper())->render('foobar', 'foo', 'pre') === 'foobar');
    }

    public function testStringChangesIfQueryIsNotFound()
    {
        $this->assertTrue((new PrefixViewHelper())->render('foobar', 'false', 'pre') === 'prefoobar');
    }

    public function testStringChangesIfQueryIsLongerThanString()
    {
        $this->assertTrue((new PrefixViewHelper())->render('foobar', 'foobarbaz', 'pre') === 'prefoobar');
    }

    public function testEvaluatesChildrenIfNoStringGiven()
    {
        $called = false;
        $renderChildren = function() use (&$called) {
            $called = true;
        };

        $viewHelper = new PrefixViewHelper();
        $viewHelper->setRenderChildrenClosure($renderChildren);
        $viewHelper->render();

        $this->assertTrue($called, 'Children should have been rendered');
    }
}
