<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Cache;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cache\CacheManager;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Get from cache view helper.
 *
 * Gets a key from a cache.
 */
class GetViewHelper extends AbstractViewHelper
{
    /**
     * @Flow\Inject
     * @var CacheManager
     */
    protected $cacheManager;

    /**
     * Main method.
     *
     * @param string $cache      Name of the cache.
     * @param string $key        Name of the cache key.
     * @return mixed
     */
    public function render($cache, $key)
    {
        return $this->cacheManager->getCache($cache)->get($key);
    }
}
