<?php
namespace Newland\NeosViewHelpers\Tests\ViewHelpers\String;

use Newland\NeosViewHelpers\ViewHelpers\String\NotEmptyViewHelper;
use PHPUnit\Framework\TestCase;

class NotEmptyViewHelperTest extends TestCase
{

    public function testStringIsEmptyIfItContainsNoCharacters()
    {
        $this->assertFalse((new NotEmptyViewHelper())->render(''));
    }

    public function testStringIsEmptyIfItContainsWhitespace()
    {
        $this->assertFalse((new NotEmptyViewHelper())->render('   '), 'Spaces should be ignored');
        $this->assertFalse((new NotEmptyViewHelper())->render("\t"), 'Tab character should be ignored');
        $this->assertFalse((new NotEmptyViewHelper())->render("\n"), 'Newlines should be ignored');
    }

    public function testStringIsEmptyIfItContainsHtmlEncodedWhitespace()
    {
        $this->assertFalse((new NotEmptyViewHelper())->render('&nbsp;'), '&nbsp; should be ignored');
    }

    public function testStringIsNotEmptyIfItContainsRegularCharacters()
    {
        $this->assertTrue((new NotEmptyViewHelper())->render('foobar'), '"foobar" is not empty');
    }

    public function testStringIsNotEmptyIfItContainsRegularCharactersSurroundedByWhitespace()
    {
        $this->assertTrue((new NotEmptyViewHelper())->render("    foobar\t"));
    }

    public function testEvaluatesChildrenIfNoStringGiven()
    {
        $called = false;
        $renderChildren = function() use (&$called) {
            $called = true;
        };

        $viewHelper = new NotEmptyViewHelper();
        $viewHelper->setRenderChildrenClosure($renderChildren);
        $viewHelper->render();

        $this->assertTrue($called, 'Children should have been rendered');
    }
}