<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Type;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Is datetime view helper.
 *
 * Checks if a given value is of type datetime.
 *
 * @example
 * <f:if condition="{formValue -> vh:type.isDateTime()}">
 *      <f:then>
 *          {formValue -> f:format.date(format: 'd.m.Y')}
 *      </f:then>
 *      <f:else>
 *          {formValue}
 *      </f:else>
 * </f:if>
 */
class IsDateTimeViewHelper extends AbstractViewHelper
{
    /**
     * @param mixed $value      The value to check.
     * @return bool
     */
    public function render($value = null): bool
    {
        $value = $value ?? $this->renderChildren();
        
        return $value instanceof \DateTime;
    }
}
