<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Media;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Media\Domain\Model\Image;

/**
 * Inline view helper.
 *
 * Outputs an inline-version of the given media node.
 */
class InlineViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param Image $image The image resource.
     * @param string $class Additional class for the SVG tag.
     * @return string|null
     */
    public function render(Image $image, $class = null)
    {
        $contents = '';
        if ($image->getMediaType() === 'image/svg+xml') {
            $contents = $this->getFileContent($image);
            if ($class) {
                $contents = $this->addClass($contents, $class);
            }
        }

        return $contents;
    }

    /**
     * Loads contents of a given image resource and returns it.
     *
     * @param Image $image
     * @return string
     */
    protected function getFileContent(Image $image): string
    {
        $stream = $image->getResource()->getStream();

        if (is_resource($stream)) {
            $contents = fread($stream, $image->getResource()->getFileSize());
            fclose($stream);
            return (string) $contents;
        }

        return '';
    }

    /**
     * Injects a class into the content.
     *
     * @param string $contents
     * @param string $class
     * @return string
     */
    protected function addClass($contents, $class): string
    {
        return str_replace(
            '<svg',
            '<svg class="' . $class . '" ',
            $contents
        );
    }
}
