# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]
### Added
- [`vh:string.notEmpty` ViewHelper ](./Classes/ViewHelpers/String/NotEmptyViewHelper.php)
  was added that makes checking for empty strings (including some edge cases like `&nbsp;`) easier.
- [`vh:type.isDateTime` ViewHelper ](./Classes/ViewHelpers/Type/IsDateTimeViewHelper.php) to
  check if the given value is a DateTime object.
- [`vh:type.isObject` ViewHelper ](./Classes/ViewHelpers/Type/IsObjectViewHelper.php) to check if
  the given value is an object in general.
- [`vh:collection.includesValue` ViewHelper ](./Classes/ViewHelpers/Collection/IncludesValueViewHelper.php) to check if the
  given collection / array contains a certain item.
- [`vh:collection.merge` ViewHelper ](./Classes/ViewHelpers/Collection/MergeViewHelper.php) to merge two
  collections / arrays.
- [`vh:collection.range` ViewHelper ](./Classes/ViewHelpers/Collection/RangeViewHelper.php) to get a new
  collection / array of numbers from a given minimum to a given maximum.
- [`vh:format.currency` ViewHelper ](./Classes/ViewHelpers/Format/CurrencyViewHelper.php) as a pre-configured version
  of the native `f:format.currency` viewhelper.
- [`vh:math.divide` ViewHelper ](./Classes/ViewHelpers/Math/DivideViewHelper.php) to divide two numbers in
  order to overcome some fluid limitations.
- [`vh:cache.get` ViewHelper ](./Classes/ViewHelpers/Cache/GetViewHelper.php) to fetch data from the cache.

### Fixed
- Package is now compatible with Neos 3.3
- `vh:math.toHours` viewhelper now zero-pads single-digit numbers