<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Media\Domain\Model\Image;

/**
 * To hours view helper.
 *
 * Converts a given number to hours and minutes.
 */
class ToHoursViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param mixed $value      The value to render.
     * @return string
     */
    public function render($value = null)
    {
        if (!$value) {
            $value = $this->renderChildren();
        }
        $hours = floor($value / 60);
        $minutes = ($value % 60);
        return "{$hours}:{$minutes}";
    }
}
