<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Media\Domain\Model\Image;

/**
 * Round view helper.
 *
 * Rounds given input.
 */
class RoundViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param mixed $value      The value to round.
     * @param int $precision    Number of digits after decimal point.
     * @return integer
     */
    public function render($value = null, $precision = 0)
    {
        if (!$value) {
            $value = $this->renderChildren();
        }
        return round(floatval($value), $precision);
    }
}
