<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Format;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Media\Domain\Model\Image;

/**
 * Json format view helper.
 *
 * Renders input as JSON.
 */
class JsonViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param mixed $value      The value to render.
     * @return string
     */
    public function render($value = null)
    {
        if (!$value) {
            $value = $this->renderChildren();
        }
        return json_encode($value);
    }
}
