<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\PersistentCollection;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Media\Domain\Model\Image;

/**
 * Slice view helper.
 *
 * Extracts a slice of a collection.
 */
class SliceViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param mixed $collection
     * @param int $offset
     * @param int $length
     * @return array
     */
    public function render($collection, $offset, $length = null)
    {
        if ($collection instanceof PersistentCollection) {
            $collection = $collection->getValues();
        }

        if (!is_array($collection)) {
            return [];
        }
        return array_slice($collection, $offset, $length);
    }
}
