<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Media\Domain\Model\Image;

/**
 * Implode view helper.
 *
 * Implodes a collection.
 */
class ImplodeViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param array $collection
     * @param string $glue
     * @return array
     */
    public function render(array $collection = null, $glue)
    {
        if (!$collection) {
            return;
        }

        return implode($collection, $glue);
    }
}
