<?php
namespace Newland\SocialGrid\Traits;

use Neos\FluidAdaptor\View\StandaloneView;

trait RendersTemplate
{

    /** @var string */
    protected $templateRootPath = 'resource://Newland.SocialGrid/Private/Templates';

    /** @var string */
    protected $partialRootPath = 'resource://Newland.SocialGrid/Private/Partials';

    /** @var string */
    protected $layoutRootPath = 'resource://Newland.SocialGrid/Private/Partials';

    protected function renderTemplate(string $templateName, array $assignments): string
    {
        $view = new StandaloneView();
        $view->setTemplateRootPaths([ $this->templateRootPath ]);
        $view->setPartialRootPaths([ $this->partialRootPath ]);
        $view->setLayoutRootPaths([ $this->layoutRootPath ]);
        $view->setTemplate($templateName);
        $view->assignMultiple($assignments);

        return trim($view->render());
    }
}
