# Neos SocialGrid Plugin.

## Compatibility

This package relies on the availability of scripts and styles provided by the
`toubiz-styleguide` package. The following table illustrates compatible versions:

| neos-socialgrid | toubiz-styleguide |
|-----------------|-------------------|
| TBD             | TBD               |


## Nodetypes

### SocialGrid 
`SocialGrid` is the main node type of this package. It acts as a wrapper for 
the other node types and handles the initialization of the masonry layout 
and loading transition.

### SocialPost 
When adding `SocialPost` nodes to a `SocialGrid`, one can choose the post type.
Currently supports intagram (default) and facebook posts. A `SocialPost` requires
setting the property `postUrl` because from this URL the following post data will be
retrieved via OEmbed API Endpoints. 

**Instagram**
- post thumbnail

**Facebook**
- post HTML

With this data the post template will be rendered based on post type.

### FollowLink
Nodes of this type can be inserted into `SocialGrid` nodes to display a
call to action in the form of a box including an icon and a label, e.g. 
"Follow us on Facebook". It has the same type selection available as
`SocialPost`. It is recommended to put this node at the beginning of a
grid node.
