<?php

namespace Newland\SocialGrid\Post;

use Newland\SocialGrid\Traits\RendersTemplate;

class FacebookPost extends OEmbedPost
{
    use RendersTemplate;
    
    const TYPE = 'facebook';
    const API_URL = 'https://www.facebook.com/plugins/post/oembed.json/?url={url}&omitscript=true&maxwidth=750';

    public function getHtml(): string
    {
        $url = str_replace('{url}', $this->configuration['url'], static::API_URL);
        $response = $this->getPostFromCacheOrApi($url);

        $postHtml = $this->fixStaticWidthInFacebookProvidedHtml($response['html']);
        return $this->renderTemplate('Post/Facebook', [ 'postHtml' => $postHtml ]);
    }

    private function fixStaticWidthInFacebookProvidedHtml(string $html): string
    {
        return str_replace('data-width="750"', 'data-width="auto"', $html);
    }

    public function getType(): string
    {
        return static::TYPE;
    }
}
