<?php

namespace Newland\SocialGrid\Post;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cache\CacheManager;

abstract class AbstractPost implements PostInterface
{
    const CACHE_NAME = 'Newland_SocialGrid-Post';

    /**
     * @Flow\Inject
     * @var CacheManager
     */
    protected $cacheManager;

    /**
     * @var array
     */
    protected $configuration;

    /**
     * Pass configuration to the created post instance.
     *
     * @param Array $configuration The configuration passed to the post instance.
     */
    public function __construct(array $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * Will be overwritten by post class extending this one.
     */
    public function getHtml(): string
    {
        return '';
    }
}
