<?php

namespace Newland\SocialGrid\Eel\Helper;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Eel\ProtectedContextAwareInterface;
use Newland\SocialGrid\Post\FacebookPost;
use Newland\SocialGrid\Post\InstagramPost;

class PostHelper implements ProtectedContextAwareInterface
{
    /**
     * Create a new post instance based on type
     *
     * @param String $type The type of post to create
     * @param String $url The post URL used for fetching post data
     * @param NodeInterface $node The SocialPost node instance
     */
    public function create(NodeInterface $node, $type, $url)
    {
        if (empty($url) || empty($node)) {
            return null;
        }

        switch ($type) {
            case InstagramPost::TYPE:
                return new InstagramPost([
                    'url' => $url,
                    'location' => $node->getProperty('postLocation'),
                ]);

            case FacebookPost::TYPE:
                return new FacebookPost([ 'url' => $url ]);

            default:
                throw new \Exception('Unknown post type ' . $type);
        }
    }

    public function allowsCallOfMethod($methodName)
    {
        return $methodName === 'create';
    }
}
