<?php

namespace Newland\SocialGrid\Post;

use Newland\SocialGrid\Traits\RendersTemplate;

class InstagramPost extends OEmbedPost
{
    use RendersTemplate;

    const TYPE = 'instagram';
    const API_URL = 'https://api.instagram.com/oembed?url={url}';

    public function getHtml(): string
    {
        $url = str_replace('{url}', $this->configuration['url'], static::API_URL);
        $response = $this->getPostFromCacheOrApi($url);

        return $this->renderTemplate(
            'Post/Instagram',
            [
                'thumbnail' => $this->downloadImage($response['thumbnail_url']),
                'postUrl' => $this->configuration['url'],
                'postLocation' => $this->configuration['location'],
                'response' => $response,
            ]
        );
    }

    public function getType(): string
    {
        return static::TYPE;
    }
}
