<?php

namespace Newland\SocialGrid\Post;

use GuzzleHttp\Client as GuzzleClient;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\ResourceManagement\ResourceManager;
use Neos\Flow\ResourceManagement\ResourceRepository;
use Neos\Media\Domain\Model\Image;
use Neos\Media\Domain\Model\ImageInterface;

abstract class OEmbedPost extends AbstractPost
{
    /**
     * @var ResourceManager
     * @Flow\Inject()
     */
    protected $resourceManager;

    /**
     * @var ResourceRepository
     * @Flow\Inject()
     */
    protected $resourceRepository;

    protected function downloadImage(string $url): ImageInterface
    {
        $thumbnail = $this->resourceManager->importResource($url);

        // Fix for query string in filename
        $fileName = explode('?', $thumbnail->getFilename())[0];
        $thumbnail->setFilename($fileName);
        $this->resourceRepository->update($thumbnail);

        return new Image($thumbnail);
    }

    protected function getPostFromCacheOrApi(string $url): array
    {
        $cache = $this->cacheManager->getCache(static::CACHE_NAME);
        $cacheKey = (string) preg_replace('/\W/', '-', $url);

        if ($cache->has($cacheKey)) {
            return $cache->get($cacheKey);
        }

        $information = $this->fetchPostFromApi($url);
        $cache->set($cacheKey, $information);
        return $information;
    }

    private function fetchPostFromApi(string $url): array
    {
        $httpClient = new GuzzleClient();
        $response = $httpClient->get($url);
        $result = json_decode($response->getBody(), true);

        if (!$result || $response->getStatusCode() !== 200) {
            return [];
        }

        return $result;
    }
}
