<?php

namespace Newland\SocialGrid\Post;

use GuzzleHttp\Client as GuzzleClient;

abstract class OEmbedPost extends AbstractPost
{
    protected function getPostFromCacheOrApi(string $url): array
    {
        $cache = $this->cacheManager->getCache(static::CACHE_NAME);
        $cacheKey = (string) preg_replace('/\W/', '-', $url);

        if ($cache->has($cacheKey)) {
            return $cache->get($cacheKey);
        }

        $information = $this->fetchPostFromApi($url);
        $cache->set($cacheKey, $information);
        return $information;
    }

    protected function fetchPostFromApi(string $url): array
    {
        $httpClient = new GuzzleClient();
        $response = $httpClient->get($url);
        $result = json_decode($response->getBody(), true);

        if (!$result || $response->getStatusCode() !== 200) {
            return [];
        }

        return $result;
    }
}
