<?php
namespace Newland\NeosRoutingBehaviourHooks\Tests\Unit\Utility;


use Neos\Flow\Tests\UnitTestCase;
use Newland\NeosRoutingBehaviourHooks\Utility\NamedDimensionCollection;

class NamedDimensionCollectionTest extends UnitTestCase
{

    /** @var NamedDimensionCollection */
    private $subject;

    public function setUp()
    {
        $this->subject = new NamedDimensionCollection([
            'de.test.com' => [ 'language' => [ 'de' ] ],
            'fr.test.com' => [ 'language' => 'fr' ],
            'en.test.com' => [ 'language' => 'en' ],
            'en.foobar.de' => [ 'language' => 'en' ]
        ]);
    }

    public function testGetsDimensionValuesByKey()
    {
        $this->assertEquals(
            [ 'language' => [ 'de' ] ],
            $this->subject->dimension('de.test.com')
        );
    }

    public function testNormalizesDimensionValues()
    {
        $this->assertEquals(
            [ 'language' => [ 'en' ] ],
            $this->subject->dimension('en.test.com')
        );
    }

    public function testGetsDimensionKeysByValues()
    {
        $this->assertEquals(
            ['fr.test.com'],
            $this->subject->keysForValues([ 'language' => [ 'fr' ] ])
        );
        $this->assertEquals(
            ['en.test.com', 'en.foobar.de'],
            $this->subject->keysForValues([ 'language' => [ 'en' ] ])
        );
    }

    public function testGetsDimensionKeyByValueForNonNormalizedValues()
    {
        $this->assertEquals(
            [ 'fr.test.com' ],
            $this->subject->keysForValues([ 'language' => 'fr' ])
        );
    }

    public function testGetsKeyThatMostCloselyResemblesReference()
    {
        $this->assertEquals(
            'en.test.com',
            $this->subject->keyForValuesMatchingReferenceMostClosely([ 'language' => [ 'en' ] ], 'en.test.com')
        );
        $this->assertEquals(
            'en.foobar.de',
            $this->subject->keyForValuesMatchingReferenceMostClosely([ 'language' => [ 'en' ] ], 'foobar.de')
        );
    }

}
