<?php declare(strict_types = 1);

namespace Newland\NeosRoutingBehaviourHooks\Tests\Unit\Utility;

use Neos\Flow\Core\ApplicationContext;
use Neos\Flow\Tests\FunctionalTestCase;
use Neos\Flow\Utility\Environment;
use Newland\NeosRoutingBehaviourHooks\Utility\EnvironmentUtility;

class EnvironmentUtilityTest extends FunctionalTestCase
{

    /** @var EnvironmentUtility */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(EnvironmentUtility::class);
    }

    public function testReturnsDevelopmentIfApplicationInDevelopmentMode(): void
    {
        $this->mockEnvironment(false, true, false, null);
        $this->assertEquals('Development', $this->subject->getEnvironment());
    }

    public function testReturnsProductionIfApplicationInProductionMode(): void
    {
        $this->mockEnvironment(true, false, false, null);

        $this->assertEquals('Production', $this->subject->getEnvironment());
    }

    public function testReturnsTestingIfApplicationInTestingMode(): void
    {
        $this->mockEnvironment(false, false, true, null);
        $this->assertEquals('Testing', $this->subject->getEnvironment());
    }

    public function testAllowsOverridingViaConfiguration(): void
    {
        // Production flow env but overriden to FooBar
        $this->mockEnvironment(true, false, false, 'FooBar');
        $this->assertEquals('FooBar', $this->subject->getEnvironment());
    }

    private function mockEnvironment(
        bool $isProduction,
        bool $isDevelopment,
        bool $isTesting,
        ?string $override
    ) {
        $context = $this->getMockBuilder(ApplicationContext::class)
            ->disableOriginalConstructor()
            ->getMock();
        $context->method('isProduction')->willReturn($isProduction);
        $context->method('isDevelopment')->willReturn($isDevelopment);
        $context->method('isTesting')->willReturn($isTesting);

        $environment = $this->getMockBuilder(Environment::class)
            ->disableOriginalConstructor()
            ->getMock();
        $environment->method('getContext')->willReturn($context);

        $this->inject($this->subject, 'environment', $environment);

        if ($override) {
            $this->inject($this->subject, 'environmentOverride', $override);
        }
    }
}
