<?php declare(strict_types = 1);

namespace Newland\NeosRoutingBehaviourHooks\Utility;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Utility\Environment;

class EnvironmentUtility
{

    /**
     * @var Environment
     * @Flow\Inject()
     */
    protected $environment;

    /**
     * @var string|null
     * @Flow\InjectConfiguration(package="Newland.NeosRoutingBehaviourHooks", path="environmentOverride")
     */
    protected $environmentOverride;

    public function getEnvironment(): string
    {
        if ($this->environmentOverride) {
            return $this->environmentOverride;
        }

        $context = $this->environment->getContext();
        if ($context->isDevelopment()) {
            return 'Development';
        }
        if ($context->isTesting()) {
            return 'Testing';
        }

        return 'Production';
    }
}
