<?php declare(strict_types=1);
namespace Newland\NeosRoutingBehaviourHooks\Foundation\IgnoreMatchedRoutes;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Aop\JoinPointInterface;
use Newland\NeosRoutingBehaviourHooks\Foundation\RouteWrappingHelper;

/**
 * @Flow\Aspect()
 */
class IgnoreMatchedNodesAspect
{

    /**
     * @var RouteWrappingHelper
     * @Flow\Inject()
     */
    protected $helper;

    /**
     * @var IgnoreContext
     * @Flow\Inject()
     */
    protected $context;

    /**
     * @Flow\Around("method(Neos\Neos\Routing\FrontendNodeRoutePartHandler->convertRequestPathToNode())")
     */
    public function convertRequestPathToNode(JoinPointInterface $joinPoint)
    {
        $result = $joinPoint->getAdviceChain()->proceed($joinPoint);
        $this->context->setNode($result);
        return $result;
    }

    /**
     * @Flow\Around("method(Neos\Flow\Mvc\Routing\Router->route())")
     */
    public function route(JoinPointInterface $joinPoint)
    {
        $this->context->setRouteContext($joinPoint->getMethodArgument('routeContext'));
        return $joinPoint->getAdviceChain()->proceed($joinPoint);
    }

    /**
     * @Flow\Around("method(Neos\Neos\Routing\FrontendNodeRoutePartHandler->matchValue())")
     */
    public function matchValue(JoinPointInterface $joinPoint)
    {
        $result = $joinPoint->getAdviceChain()->proceed($joinPoint);
        return $result && $this->proceed();
    }

    private function proceed(): bool
    {
        foreach ($this->behaviours() as $behaviour) {
            if ($behaviour->ignoreMatchedNode($this->context)) {
                return false;
            }
        }

        return true;
    }

    /**
     * @return IgnoresMatchedNode[]
     */
    private function behaviours(): array
    {
        return array_filter(
            $this->helper->behaviours(),
            function ($behaviour) {
                return $behaviour instanceof IgnoresMatchedNode;
            }
        );
    }
}
