<?php declare(strict_types=1);
namespace Newland\NeosRoutingBehaviourHooks\Foundation\CustomDimensionResolution;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Aop\JoinPointInterface;
use Newland\NeosRoutingBehaviourHooks\Foundation\RouteWrappingHelper;

/**
 * @Flow\Aspect()
 */
class CustomDimensionResolutionAspect
{

    /**
     * @var RouteWrappingHelper
     * @Flow\Inject()
     */
    protected $helper;

    /**
     * @var DimensionResolutionContext
     *
     * @Flow\Inject(lazy = false)
     */
    protected $context;

    /**
     * @Flow\Around("method(Neos\Flow\Mvc\Routing\Router->route())")
     */
    public function route(JoinPointInterface $joinPoint)
    {
        $this->context->setRouteContext($joinPoint->getMethodArgument('routeContext'));
        return $joinPoint->getAdviceChain()->proceed($joinPoint);
    }

    /**
     * phpcs:disable Generic.Files.LineLength.TooLong
     * @Flow\Around("method(Neos\Neos\Routing\FrontendNodeRoutePartHandler->parseDimensionsAndNodePathFromRequestPath())")
     * phpcs:enable
     */
    public function parseDimensionsAndNodePathFromRequestPath(JoinPointInterface $joinPoint): array
    {
        /** @var string $path */
        $path = $joinPoint->getMethodArgument('requestPath');
        return $this->parseCustomDimensions($path) ?? $joinPoint->getAdviceChain()->proceed($joinPoint);
    }

    /**
     * @Flow\Around("method(Neos\Neos\Routing\FrontendNodeRoutePartHandler->getUriSegmentForDimensions())")
     */
    public function getUriSegmentForDimensions(JoinPointInterface $joinPoint): string
    {
        /** @var array $dimensions */
        $dimensions = $joinPoint->getMethodArgument('dimensionsValues');

        foreach ($this->behaviours() as $behaviour) {
            $uriSegment = $behaviour->resolveDimensions($this->context, $dimensions);
            if ($uriSegment !== null) {
                return $uriSegment;
            }
        }

        return $joinPoint->getAdviceChain()->proceed($joinPoint);
    }

    /**
     * @param string $path
     * @return array|null
     */
    private function parseCustomDimensions(string $path)
    {
        foreach ($this->behaviours() as $behaviour) {
            $dimensions = $behaviour->parseDimensions($this->context, $path);
            if ($dimensions !== null) {
                return $dimensions;
            }
        }

        return null;
    }

    /**
     * @return CustomDimensionResolution[]
     */
    private function behaviours(): array
    {
        return array_filter(
            $this->helper->behaviours(),
            function ($behaviour) {
                return $behaviour instanceof CustomDimensionResolution;
            }
        );
    }
}
