<?php declare(strict_types=1);
namespace Newland\NeosRoutingBehaviourHooks\Foundation\SeparateRouteCache;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Aop\JoinPointInterface;
use Newland\NeosRoutingBehaviourHooks\Foundation\RouteWrappingHelper;

/**
 * @Flow\Aspect()
 */
class SeparateRouteCacheAspect
{

    /**
     * @var RouteWrappingHelper
     * @Flow\Inject()
     */
    protected $helper;

    /**
     * @Flow\Around("method(Neos\Flow\Mvc\Routing\RouterCachingService->convertObjectsToHashes())")
     */
    public function convertObjectsToHashes(JoinPointInterface $joinPoint): ?array
    {
        $cacheTags = $joinPoint->getAdviceChain()->proceed($joinPoint);
        if ($cacheTags === null) {
            return null;
        }

        return $this->extendRouteValuesWithCustomCacheTags($cacheTags);
    }

    private function extendRouteValuesWithCustomCacheTags(array $routeValues): array
    {
        foreach ($this->behaviours() as $behaviour) {
            foreach ($behaviour->getRouteCacheTags() as $name => $value) {
                $key = \get_class($behaviour) . '|' . $name;
                $routeValues[$key] = $value;
            }
        }
        return $routeValues;
    }

    /**
     * @return SeparateRouteCache[]
     */
    private function behaviours(): array
    {
        return array_filter(
            $this->helper->behaviours(),
            static fn ($behaviour) => $behaviour instanceof SeparateRouteCache
        );
    }
}
