<?php declare(strict_types=1);
namespace Newland\NeosRoutingBehaviourHooks\Foundation;

use Neos\Flow\Annotations as Flow;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;

class RouteParameterExtractor implements MiddlewareInterface
{
    /**
     * @var RouteWrappingHelper
     * @Flow\Inject()
     */
    protected $helper;

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $this->helper->setUri($request->getUri());
        return $handler->handle($request);
    }
}
