<?php declare(strict_types=1);
namespace Newland\NeosRoutingBehaviourHooks\Foundation\ModifyResolveContext;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Aop\JoinPointInterface;
use Neos\Flow\Mvc\Routing\Dto\ResolveContext;
use Newland\NeosRoutingBehaviourHooks\Foundation\RouteWrappingHelper;

/**
 * @Flow\Aspect()
 */
class ModifyResolveContextAspect
{

    /**
     * @var RouteWrappingHelper
     * @Flow\Inject()
     */
    protected $helper;

    /**
     * @Flow\Around("method(Neos\Flow\Mvc\Routing\Router->resolve())")
     */
    public function resolve(JoinPointInterface $joinPoint)
    {
        /** @var ResolveContext $context */
        $context = $joinPoint->getMethodArgument('resolveContext');

        foreach ($this->behaviours() as $behaviour) {
            $context = $behaviour->modifyResolveContextBeforeResolving($context);
        }

        $joinPoint->setMethodArgument('resolveContext', $context);
        return $joinPoint->getAdviceChain()->proceed($joinPoint);
    }

    /**
     * @return ModifyResolveContext[]
     */
    private function behaviours(): array
    {
        return array_filter(
            $this->helper->behaviours(),
            static fn ($behaviour) => $behaviour instanceof ModifyResolveContext
        );
    }
}
