<?php declare(strict_types=1);

namespace Newland\NeosRoutingBehaviourHooks\Tests\Unit\Utility;

use Neos\Flow\Tests\UnitTestCase;
use Newland\NeosRoutingBehaviourHooks\Utility\UrlUtility;

class UrlUtilityTest extends UnitTestCase
{

    /** @dataProvider provideHostnames */
    public function testStripsOutDuplicateHostnames(string $input, string $expected): void
    {
        $this->assertEquals(
            $expected,
            UrlUtility::stripOutDuplicateHostsInUrl($input)
        );
    }

    public function provideHostnames(): array
    {
        return [
            'duplicate' => [ 'http://foobar.com/http://foobar.com/some-test', 'http://foobar.com/some-test' ],
            'duplicate https' => [ 'https://foobar.com/https://foobar.com/some-test', 'https://foobar.com/some-test' ],
            'duplicate different' => [ 'https://foo.com/http://bar.com/some-test', 'http://bar.com/some-test' ],
            'not duplicate' => [ 'https://test.com', 'https://test.com' ],
            'relative' => [ '/foo/bar', '/foo/bar' ],
            'url encoded url inside' => [ 'https://test.com/check?url=' . urlencode('https://twitter.com'), 'https://test.com/check?url=' . urlencode('https://twitter.com') ]
        ];
    }

}
