<?php declare(strict_types=1);
namespace Newland\NeosRoutingBehaviourHooks\Foundation\CustomDimensionResolution;

interface CustomDimensionResolution
{

    /**
     * Parses a request URI into an array of dimension values.
     * If an array is returned then this array will be used as dimension values,
     * If null is returned then this behaviour will have no impact.
     *
     * @param DimensionResolutionContext $context
     * @param string $requestPath
     * @return array|null
     */
    public function parseDimensions(DimensionResolutionContext $context, string $requestPath): ?array;

    /**
     * Resolves the given array of dimension values into a uri segment.
     * If a string is returned then this string will be used in the uri path,
     * If null is returned then this behaviour will have no impact.
     *
     * @param DimensionResolutionContext $context
     * @param array $dimensions
     * @return string|null
     */
    public function resolveDimensions(DimensionResolutionContext $context, array $dimensions): ?string;
}
